//
//  MCWorkspace.h
//  MCApplication
//
//  Created by Ali Lalani on 7/5/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "MCDisplayStateProtocol.h"

@class MCDocument;

@interface MCWindowWorkspace : NSObject {
	NSMutableDictionary *configuration;

	NSString *name;
	MCDocument *document;
}

- (id)initWithConfiguration:(NSMutableDictionary *)aDict document:(id)aDocument;

- (void)loadWorkspace;
- (void)unloadWorkspace;

- (void)addWindowControllerConfiguration:(NSMutableDictionary *)aDict;
- (void)removeWindowController:(id <MCDisplayState>)aCtl;
- (void)addWindowController:(id <MCDisplayState>)aCtl;

#pragma mark Accessors
- (NSString *)name;
- (void)setName:(NSString *)aName;
- (MCDocument *)document;
- (void)setDocument:(MCDocument *)aDocument;
- (NSMutableDictionary *)configuration;
- (void)setConfiguration:(NSMutableDictionary *)aConfiguration;
@end
